/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.base.saverest.CustomizableData;
import com.ibm.hwmca.fw.attn.Attention;
import com.ibm.hwmca.fw.attn.AttentionID;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.managed.AlreadyBusyException;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.HwmcaParentObject;
import com.ibm.hwmca.fw.managed.ManagedObjectGroup;
import com.ibm.hwmca.fw.managed.ManagedObjectProperties;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Status;
import com.ibm.hwmca.fw.managed.StatusQuery;
import com.ibm.hwmca.fw.managed.UserDefinedManagedObjectGroup;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.settings.user.ObjectLockingSettings;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ManagedObject
extends HwmcaParentObject
implements StatusQuery,
ManagedObjectProperties {
    private Set permittedTasks;
    protected String targetId;
    protected String name;
    protected boolean busy;
    protected HashSet supportedStatus = new HashSet();
    protected HashSet acceptableStatus = new HashSet();
    protected Status status = Status.NOT_COMMUNICATING;
    protected boolean groupable;
    protected CompletionReport lastTaskReport;
    protected LocalizableText lastTaskName;
    protected ArrayList attentions = new ArrayList();
    protected boolean lastIsStatusAcceptable = false;
    protected ObjectId openTaskObjectId;
    protected ObjectId attentionTaskObjectId;
    protected boolean locked;
    private Object acceptableStatusMonitor = new Object();
    private Object supportedStatusMonitor = new Object();
    private Object permittedTasksMonitor = new Object();
    private Object attentionMonitor = new Object();
    private static Object classMapMonitor = new Object();
    private static Map classMap;
    private static final FrameworkClassLogInfo logInfo;
    private static final String TRACE_MASKT = "XFRMMOBT";
    private static final String TRACE_MASKF = "XFRMMOBF";
    private static final String TRACE_MASKD = "XFRMMOBD";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObject$SaveRestore;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObject;

    protected ManagedObject() {
        this.targetId = this.getClass().getName();
        this.permittedTasks = new HashSet();
        ObjectLockingSettings settings = ObjectLockingSettings.getObjectLockingSettings();
        if (settings.getLock()) {
            this.locked = true;
        }
    }

    protected ManagedObject(PersistentData data, String persistKey) {
        super(((Persistent)data).parentData, persistKey);
        this.targetId = ((Persistent)data).targetId;
        this.name = ((Persistent)data).name;
        this.acceptableStatus = ((Persistent)data).acceptableStatus;
        this.groupable = ((Persistent)data).groupable;
        this.lastTaskReport = ((Persistent)data).lastTaskReport;
        this.lastTaskName = ((Persistent)data).lastTaskName;
        this.openTaskObjectId = ((Persistent)data).openTaskObjectId;
        this.attentionTaskObjectId = ((Persistent)data).attentionTaskObjectId;
        this.locked = ((Persistent)data).locked;
    }

    public String getTargetId() {
        return this.targetId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetId(String targetId) {
        Trace.trace(TRACE_MASKT, "-> setTargetId(targetId=" + targetId + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            String oldTargetId = this.targetId;
            this.targetId = targetId;
            this.firePropertyChange("TargetId", oldTargetId, targetId);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKT, "<- setTargetId()");
    }

    public String getName() {
        return this.name;
    }

    public boolean isBusy() {
        return this.busy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBusy(boolean busy) throws AlreadyBusyException {
        Trace.trace(TRACE_MASKT, "-> setBusy(isBusy=" + busy + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            if (this.busy && busy) {
                throw new AlreadyBusyException(this);
            }
            boolean oldBusy = this.busy;
            this.busy = busy;
            this.firePropertyChange("Busy", oldBusy, busy);
        }
        Trace.trace(TRACE_MASKT, "<- setBusy()");
    }

    public boolean isLocked() {
        return this.locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocked(boolean locked) {
        Trace.trace(TRACE_MASKT, "-> setLocked(locked=" + locked + ")");
        if (this.locked != locked) {
            Object object = this.getPropertyChangeMonitor();
            synchronized (object) {
                this.locked = locked;
                this.firePropertyChange("Locked", !locked, locked);
            }
            this.autoPersist();
            ManagedObject.createLockEvent(this.getUIInfo(), locked);
        }
        Trace.trace(TRACE_MASKT, "<- setLocked()");
    }

    public boolean isGroupable() {
        return this.groupable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroupable(boolean groupable) {
        Trace.trace(TRACE_MASKT, "-> setGroupable(isGroupable=" + groupable + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            boolean oldGroupable = this.groupable;
            this.groupable = groupable;
            this.firePropertyChange("Groupable", oldGroupable, groupable);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKT, "<- setGroupable()");
    }

    public CompletionReport getLastTaskReport() {
        return this.lastTaskReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastTaskReport(CompletionReport lastTaskReport) {
        Trace.trace(TRACE_MASKT, "-> setLastTaskReport(report=" + lastTaskReport + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            CompletionReport oldReport = this.lastTaskReport;
            this.lastTaskReport = lastTaskReport;
            this.firePropertyChange("LastTaskReport", oldReport, lastTaskReport);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKT, "<- setLastTaskReport()");
    }

    public LocalizableText getLastTaskName() {
        return this.lastTaskName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastTaskName(LocalizableText name) {
        Trace.trace(TRACE_MASKT, "-> setLastTaskName(name=" + name + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            LocalizableText oldName = this.lastTaskName;
            this.lastTaskName = name;
            this.firePropertyChange("LastTaskName", oldName, name);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKT, "<- setLastTaskName()");
    }

    public Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(Status status) {
        Trace.trace(TRACE_MASKT, "-> setStatus(status=" + status + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            if (!this.getSupportedStatus().contains(status)) {
                throw new IllegalArgumentException("Status " + status + " is not supported");
            }
            Status oldStatus = this.status;
            this.status = status;
            this.firePropertyChange("Status", oldStatus, status);
            boolean statusAcceptable = this.isStatusAcceptable();
            this.firePropertyChange("StatusAcceptable", this.lastIsStatusAcceptable, statusAcceptable);
            this.lastIsStatusAcceptable = statusAcceptable;
        }
        Trace.trace(TRACE_MASKT, "<- setStatus()");
    }

    public boolean isStatusAcceptable() {
        return this.getAcceptableStatus().contains(this.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAcceptableStatus() {
        Object object = this.acceptableStatusMonitor;
        synchronized (object) {
            return (Set)this.acceptableStatus.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAcceptableStatus(Set acceptableStatus) {
        Trace.trace(TRACE_MASKT, "-> setAcceptableStatus(acceptableStatus=" + acceptableStatus + ")");
        Status[] oldAcceptableStatus = null;
        Status[] newAcceptableStatus = null;
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Set currentSupportedStatus = this.getSupportedStatus();
            Object object2 = this.acceptableStatusMonitor;
            synchronized (object2) {
                Iterator iterator = acceptableStatus.iterator();
                while (iterator.hasNext()) {
                    Status status = (Status)iterator.next();
                    if (currentSupportedStatus.contains(status)) continue;
                    throw new IllegalArgumentException("Status " + status + " is not in the supported status list for object " + this);
                }
                if (this.acceptableStatus != null) {
                    oldAcceptableStatus = new Status[this.acceptableStatus.size()];
                    this.acceptableStatus.toArray(oldAcceptableStatus);
                }
                if (acceptableStatus != null) {
                    newAcceptableStatus = new Status[acceptableStatus.size()];
                    acceptableStatus.toArray(newAcceptableStatus);
                }
                this.acceptableStatus.clear();
                this.acceptableStatus.addAll(acceptableStatus);
            }
            this.firePropertyChange("AcceptableStatus", oldAcceptableStatus, newAcceptableStatus);
            boolean statusAcceptable = this.isStatusAcceptable();
            this.firePropertyChange("StatusAcceptable", this.lastIsStatusAcceptable, statusAcceptable);
            this.lastIsStatusAcceptable = statusAcceptable;
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKT, "<- setAcceptableStatus()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getSupportedStatus() {
        Object object = this.supportedStatusMonitor;
        synchronized (object) {
            return (Set)this.supportedStatus.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOpenTaskObjectId(ObjectId openTaskObjectId) {
        Trace.trace(TRACE_MASKF, "-> setOpenTaskObjectId(openTaskObjectId=" + openTaskObjectId + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            ObjectId oldOpenTaskObjectId = this.openTaskObjectId;
            this.openTaskObjectId = openTaskObjectId;
            this.firePropertyChange("OpenTaskObjectId", oldOpenTaskObjectId, this.openTaskObjectId);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- setOpenTaskObjectId()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttentionTaskObjectId(ObjectId attentionTaskObjectId) {
        Trace.trace(TRACE_MASKF, "-> setAttentionTaskObjectId(attentionTaskObjectId=" + attentionTaskObjectId + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            ObjectId oldTaskObjectId = this.attentionTaskObjectId;
            this.attentionTaskObjectId = attentionTaskObjectId;
            this.firePropertyChange("AttentionTaskObjectId", oldTaskObjectId, this.attentionTaskObjectId);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- setAttentionTaskObjectId()");
    }

    public ObjectId getOpenTaskObjectId() {
        return this.openTaskObjectId;
    }

    public ObjectId getAttentionTaskObjectId() {
        if (this.attentionTaskObjectId == null) {
            return ManagedObject.getDefaultAttentionTaskObjectId();
        }
        return this.attentionTaskObjectId;
    }

    public static ObjectId getDefaultAttentionTaskObjectId() {
        ObjectId objectId = new ObjectId("com.ibm.hwmca.fw.managed", "Task");
        objectId.setKeyProperty("Name", "base.task.hwmsg");
        return objectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttention(Attention attention) {
        Trace.trace(TRACE_MASKT, "-> ManagedObject.addAttention(attention=" + attention + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            int oldSize;
            boolean found = false;
            int newSize = 0;
            Object object2 = this.attentionMonitor;
            synchronized (object2) {
                oldSize = this.attentions.size();
                found = this.attentions.contains(attention);
                if (!found) {
                    this.attentions.add(attention);
                    newSize = this.attentions.size();
                }
            }
            if (!found) {
                this.fireContainerPropertyAdd("Attentions", new Attention[]{attention});
            }
            if (oldSize == 0 && newSize > 0) {
                this.firePropertyChange("AttentionsExist", false, true);
            }
        }
        Trace.trace(TRACE_MASKT, "<- ManagedObject.addAttention()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttentions(Collection attentions) {
        Trace.trace(TRACE_MASKT, "-> addAttentions(attentions=" + attentions + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            int newSize;
            int oldSize;
            Object object2 = this.attentionMonitor;
            synchronized (object2) {
                oldSize = this.attentions.size();
                this.attentions.addAll(attentions);
                newSize = this.attentions.size();
            }
            Attention[] attentionArray = new Attention[attentions.size()];
            attentions.toArray(attentionArray);
            this.fireContainerPropertyAdd("Attentions", attentionArray);
            if (oldSize == 0 && newSize > 0) {
                this.firePropertyChange("AttentionsExist", false, true);
            }
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKT, "<- addAttentions()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAttention(Attention attention) {
        Trace.trace(TRACE_MASKT, "-> ManagedObject.removeAttention(attention=" + attention + ")");
        boolean found = false;
        int newSize = 1;
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            int oldSize;
            Object object2 = this.attentionMonitor;
            synchronized (object2) {
                oldSize = this.attentions.size();
                found = this.attentions.contains(attention);
                if (found) {
                    this.attentions.remove(attention);
                    newSize = this.attentions.size();
                }
            }
            if (found) {
                this.fireContainerPropertyRemove("Attentions", attention);
            }
            if (oldSize > 0 && newSize == 0) {
                this.firePropertyChange("AttentionsExist", true, false);
            }
        }
        Trace.trace(TRACE_MASKT, "<- ManagedObject.removeAttention()");
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAttentions(Collection attentions) {
        boolean removed;
        Trace.trace(TRACE_MASKT, "-> removeAttentions(attentions=" + attentions + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            int newSize;
            int oldSize;
            Attention[] attentionArray = null;
            Object object2 = this.attentionMonitor;
            synchronized (object2) {
                oldSize = this.attentions.size();
                ArrayList oldList = (ArrayList)this.attentions.clone();
                removed = this.attentions.removeAll(attentions);
                if (removed) {
                    oldList.removeAll(this.attentions);
                    attentionArray = new Attention[oldList.size()];
                    oldList.toArray(attentionArray);
                }
                newSize = this.attentions.size();
            }
            if (removed) {
                this.fireContainerPropertyRemove("Attentions", attentionArray);
            }
            if (oldSize > 0 && newSize == 0) {
                this.firePropertyChange("AttentionsExist", true, false);
            }
        }
        if (removed) {
            this.autoPersist();
        }
        Trace.trace(TRACE_MASKT, "<- removeAttentions(returns " + removed + ")");
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAttentions() {
        Trace.trace(TRACE_MASKT, "-> removeAllAttentions()");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Attention[] attentionArray;
            int oldSize;
            Object object2 = this.attentionMonitor;
            synchronized (object2) {
                oldSize = this.attentions.size();
                attentionArray = new Attention[this.attentions.size()];
                this.attentions.toArray(attentionArray);
                this.attentions.clear();
            }
            this.fireContainerPropertyRemove("Attentions", attentionArray);
            if (oldSize > 0) {
                this.firePropertyChange("AttentionsExist", true, false);
            }
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKT, "<- removeAllAttentions()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attention getAttention(AttentionID attnId) {
        Trace.trace(TRACE_MASKT, "-> ManagedObject.getAttention(Id=" + attnId + ")");
        Attention result = null;
        Object object = this.attentionMonitor;
        synchronized (object) {
            Iterator iterator = this.attentions.iterator();
            while (iterator.hasNext() && result == null) {
                Attention attn = (Attention)iterator.next();
                if (!attnId.equals(attn.getAttentionID())) continue;
                result = attn;
            }
        }
        Trace.trace(TRACE_MASKT, "<- ManagedObject.getAttention()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAttentions() {
        Object object = this.attentionMonitor;
        synchronized (object) {
            return (List)this.attentions.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAttentionsExist() {
        Object object = this.attentionMonitor;
        synchronized (object) {
            return this.attentions.size() > 0;
        }
    }

    public void addedToGroup(UserDefinedManagedObjectGroup toGroup, ManagedObjectGroup fromGroup) {
    }

    public void removedFromGroup(UserDefinedManagedObjectGroup group) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getInterfaceImpl(Class interfaceId) {
        Trace.trace(TRACE_MASKT, "-> getInterfaceImpl(interfaceId=" + interfaceId + ")");
        Object result = null;
        if (interfaceId.isAssignableFrom(this.getClass())) {
            result = this;
        } else {
            Object object = classMapMonitor;
            synchronized (object) {
                Map utilities = ManagedObject.getClassMap();
                for (Class<?> classId = this.getClass(); classId != null && result == null; classId = classId.getSuperclass()) {
                    Map interfaces = (Map)utilities.get(classId.getName());
                    if (interfaces == null || !((result = interfaces.get(interfaceId.getName())) instanceof String)) continue;
                    Exception exception = null;
                    if (((String)result).endsWith("^")) {
                        try {
                            result = ((String)result).substring(0, ((String)result).length() - 1);
                            result = Class.forName((String)result).newInstance();
                            interfaces.put(interfaceId.getName(), result);
                            Trace.trace(TRACE_MASKD, "Lazy instantiated: " + interfaceId.getName());
                        }
                        catch (Exception exc) {
                            exception = exc;
                        }
                    } else {
                        try {
                            Class<?> implClass = Class.forName((String)result);
                            try {
                                Constructor<?> constructor = implClass.getConstructor(classId);
                                result = constructor.newInstance(this);
                            }
                            catch (NoSuchMethodException e) {
                                result = implClass.newInstance();
                            }
                        }
                        catch (ClassNotFoundException exc) {
                            exception = exc;
                        }
                        catch (InstantiationException exc) {
                            exception = exc;
                        }
                        catch (IllegalAccessException exc) {
                            exception = exc;
                        }
                        catch (InvocationTargetException exc) {
                            exception = exc;
                        }
                    }
                    if (exception == null) continue;
                    FrameworkLog log = new FrameworkLog(logInfo, 2450, exception);
                    log.add("Could not instantiate class: " + result);
                    log.log();
                    result = null;
                    break;
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- getInterfaceImpl(returns " + (result == null ? "null" : result.getClass().getName()));
        return result;
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.parentData = super.getPersistentData();
        result.targetId = this.targetId;
        result.name = this.name;
        result.acceptableStatus = (HashSet)this.getAcceptableStatus();
        result.groupable = this.groupable;
        result.lastTaskReport = this.lastTaskReport;
        result.lastTaskName = this.lastTaskName;
        result.openTaskObjectId = this.openTaskObjectId;
        result.attentionTaskObjectId = this.attentionTaskObjectId;
        result.locked = this.locked;
        return result;
    }

    protected void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSupportedStatus(Set supportedStatus) {
        Trace.trace(TRACE_MASKT, "-> setSupportedStatus(supportedStatus=" + supportedStatus + ")");
        Status[] oldSupportedStatus = null;
        Status[] newSupportedStatus = null;
        boolean acceptableStatusChanged = false;
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Set currentAcceptableStatus = this.getAcceptableStatus();
            Object object2 = this.supportedStatusMonitor;
            synchronized (object2) {
                Iterator iterator = currentAcceptableStatus.iterator();
                while (iterator.hasNext()) {
                    Status status = (Status)iterator.next();
                    if (supportedStatus.contains(status)) continue;
                    Trace.trace(TRACE_MASKF, "acceptable status " + status + " is not in the new supported status list.  " + "It is being removed.");
                    iterator.remove();
                    acceptableStatusChanged = true;
                }
                if (this.supportedStatus != null) {
                    oldSupportedStatus = new Status[this.supportedStatus.size()];
                    this.supportedStatus.toArray(oldSupportedStatus);
                }
                if (supportedStatus != null) {
                    newSupportedStatus = new Status[supportedStatus.size()];
                    supportedStatus.toArray(newSupportedStatus);
                }
                this.supportedStatus.clear();
                this.supportedStatus.addAll(supportedStatus);
            }
            this.firePropertyChange("SupportedStatus", oldSupportedStatus, newSupportedStatus);
            if (acceptableStatusChanged) {
                object2 = this.setAutoPersist(false);
                synchronized (object2) {
                    try {
                        this.setAcceptableStatus(currentAcceptableStatus);
                    }
                    finally {
                        this.setAutoPersist(true);
                    }
                }
            }
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKT, "<- setSupportedStatus()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addClassInterfaceImpl(Class classId, Class interfaceId, Object implementation) {
        Trace.trace(TRACE_MASKT, "<> addClassInterfaceImpl(classId=" + classId + ",interfaceId=" + interfaceId + ")");
        Object object = classMapMonitor;
        synchronized (object) {
            Map map = ManagedObject.getClassMap();
            HashMap<String, Object> interfaces = (HashMap<String, Object>)ManagedObject.getClassMap().get(classId.getName());
            if (interfaces == null) {
                interfaces = new HashMap<String, Object>();
                map.put(classId.getName(), interfaces);
            }
            interfaces.put(interfaceId.getName(), implementation);
        }
    }

    private static Map getClassMap() {
        if (classMap == null) {
            classMap = new HashMap();
        }
        return classMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getPermittedTasks() {
        Set set = this.permittedTasks;
        synchronized (set) {
            return this.permittedTasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPermittedTask(ObjectId permittedTask) {
        boolean exists;
        Trace.trace(TRACE_MASKF, "-> addPermittedTask(permittedTask=" + permittedTask + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Object object2 = this.permittedTasksMonitor;
            synchronized (object2) {
                exists = this.permittedTasks.contains(permittedTask);
                if (!exists) {
                    this.permittedTasks.add(permittedTask);
                }
            }
        }
        if (!exists) {
            this.autoPersist();
        }
        Trace.trace(TRACE_MASKF, "<- addPermittedTask()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPermittedTasks(Collection newTasks) {
        if (newTasks != null) {
            Set set = this.permittedTasks;
            synchronized (set) {
                this.permittedTasks.addAll(newTasks);
            }
        }
        this.autoPersist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermittedTasks(Set newTasks) {
        Set set = this.permittedTasks;
        synchronized (set) {
            this.permittedTasks.clear();
            this.permittedTasks.addAll(newTasks);
        }
        this.autoPersist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskPermitted(ObjectId objectId) {
        boolean result = false;
        Set set = this.permittedTasks;
        synchronized (set) {
            result = this.permittedTasks.contains(objectId);
            if (!result) {
                result = this.permittedTasks.contains(objectId.getClassId());
            }
        }
        return result;
    }

    public static void createLockEvent(UIInfo uiInfo, boolean locked) {
        UserContext uc = UserContext.getCurrentUserContext();
        String userName = uc.isSystem() ? new LocalizableText("com/ibm/hwmca/fw/res/common", "datarepapp.user").toString() : uc.getUserid();
        String[] subVars = new String[]{uiInfo.getTitle(), userName};
        short id = locked ? (short)944 : 945;
        String name = locked ? "LOCKOBJECT" : "UNLOCKOBJECT";
        FrameworkEventText text = new FrameworkEventText(id, subVars);
        new SystemEventLog(text, name).log();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logInfo = new FrameworkClassLogInfo(85, "ManagedObject");
    }

    public static class SaveRestore
    implements CustomizableData {
        private static String TEXT = "acceptablestatus.text";
        private static String CAPTION = "acceptablestatus.caption";
        private static String customDataKey = (class$com$ibm$hwmca$fw$managed$ManagedObject$SaveRestore == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject$SaveRestore = ManagedObject.class$("com.ibm.hwmca.fw.managed.ManagedObject$SaveRestore")) : class$com$ibm$hwmca$fw$managed$ManagedObject$SaveRestore).getName();

        public UIInfo getUIInfo() {
            Trace.trace(ManagedObject.TRACE_MASKT, "<> SaveRestore.getUIInfo()");
            return new UIInfo(new LocalizableText("com/ibm/hwmca/fw/res/common", TEXT), new LocalizableText("com/ibm/hwmca/fw/res/common", CAPTION));
        }

        public Serializable getSaveableData() {
            Trace.trace(ManagedObject.TRACE_MASKT, "-> SaveRestore.getSaveableData()");
            Set ids = HwmcaObject.mom.getInventoryObjectIds(new ClassId(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject = ManagedObject.class$("com.ibm.hwmca.fw.managed.ManagedObject")) : class$com$ibm$hwmca$fw$managed$ManagedObject));
            HashMap<String, Object> data = new HashMap<String, Object>(ids.size());
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                ObjectId id = (ObjectId)iterator.next();
                Trace.trace(ManagedObject.TRACE_MASKF, "saving data for object " + id);
                try {
                    Object acceptableStatus = HwmcaObject.mom.getProperty(id, "AcceptableStatus");
                    data.put(id.toString(), acceptableStatus);
                }
                catch (Exception exc) {
                    Trace.trace(ManagedObject.TRACE_MASKF, "Error saving acceptable status data");
                    Trace.trace(ManagedObject.TRACE_MASKF, exc);
                }
            }
            Trace.trace(ManagedObject.TRACE_MASKT, "<- SaveRestore.getSaveableData()");
            return data;
        }

        public void restoreData(Serializable obj) {
            Trace.trace(ManagedObject.TRACE_MASKT, "-> SaveRestore.restoreData(obj.class=" + obj.getClass().getName() + ")");
            Set entries = ((Map)((Object)obj)).entrySet();
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ObjectId id = new ObjectId((String)entry.getKey());
                Object acceptableStatus = entry.getValue();
                Trace.trace(ManagedObject.TRACE_MASKF, "restoring data for object " + id);
                try {
                    HwmcaObject.mom.setProperty(id, "AcceptableStatus", acceptableStatus);
                }
                catch (Exception exc) {
                    Trace.trace(ManagedObject.TRACE_MASKF, "Error restoring acceptable status data");
                    Trace.trace(ManagedObject.TRACE_MASKF, exc);
                }
            }
            Trace.trace(ManagedObject.TRACE_MASKT, "<- SaveRestore.restoreData()");
        }

        public String getCustomDataKey() {
            Trace.trace(ManagedObject.TRACE_MASKT, "<> SaveRestore.getCustomDataKey()");
            return customDataKey;
        }
    }

    private static class Persistent
    implements PersistentData {
        int version = 0;
        PersistentData parentData;
        String targetId;
        String name;
        HashSet acceptableStatus;
        boolean groupable;
        CompletionReport lastTaskReport;
        LocalizableText lastTaskName;
        ObjectId openTaskObjectId;
        ObjectId attentionTaskObjectId;
        boolean locked;
        private static final long serialVersionUID = -195897903137260525L;

        private Persistent() {
        }
    }
}

